/**
 * 
 */
package gov.va.med.mhv.integration.phr.service.cds;

import gov.va.med.mhv.integration.phr.dao.PhrBaseDAO;
import gov.va.med.mhv.integration.phr.dao.PhrChemistryDAOImpl;
import gov.va.med.mhv.integration.phr.enumeration.ExtractType;
import gov.va.med.mhv.integration.phr.message.MessageSelector;
import gov.va.med.mhv.integration.phr.service.QueryService;
import gov.va.med.mhv.integration.phr.service.vistaweb.cache.CacheHandler;
import gov.va.med.mhv.integration.phr.transfer.QueryRequest;

import java.util.Date;
import java.util.Hashtable;

/**
 * @author DNS
 *
 * We need this base class because we're doing some special caching of the 
 * history of the chemistry data.
 * 
 * TODO: Need to determine how this is used and whether it's needed or not.
 */
@MessageSelector(messageName=QueryService.messageName, extractType= ExtractType.CHEMISTRY)
public abstract class AbstractBaseChemistryQueryService extends AbstractBaseCdsQueryService {

	@Override
	protected void updateCacheHandler(QueryRequest request, PhrBaseDAO phrDao) {
		super.updateCacheHandler(request, phrDao);
		
		if(phrDao instanceof PhrChemistryDAOImpl)
		{
			PhrChemistryDAOImpl phrChemDao = (PhrChemistryDAOImpl)phrDao;
			Hashtable<String, Date>chemHistMap = phrChemDao.fetchPHRChemistryHistory(CacheHandler.getInstance().getPatientId(request.getIcn()));
			CacheHandler.getInstance().setChemistryHistory(chemHistMap);
		}
	}

}
